//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Foundational Types
//:
//: In Swift, the 8 foundational types are:
//:
//: * `Int` - a whole number. Also known as an integer.
//: * `Float` - a decimal number (6 decimal places).
//: * `Double` - a decimal number (15 decimal places).
//: * `Bool` - a boolean value. Either `true` or `false`.
//: * `String` - some text. Also known as a string of characters.
//: * `Array` - an ordered list.
//: * `Dictionary` - a library to store a value against a unique ID.
//: * `Set` - a pool of unique values.
//:
//: Execute the code below.
//:
//: -------------------
//:
//: [Next Page  ▶](@next)
//:
//: -------------------
//:


let wholeNumber: Int = 100
let decimalNumber: Float = 100.123456
let decimalNumberWithIncreasedAccuracy: Double = 100.123456789012345
let boolean: Bool = true
let text: String = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
let array: Array<Int> = [1, 2, 3, 4, 5]
let dictionary: Dictionary<String, Int> = ["key1": 1, "key2": 2, "key3": 3, "key4": 4, "key5": 5]
let set: Set<Int> = [1, 2, 3, 4, 5]

print(wholeNumber)
print(decimalNumber)
print(decimalNumberWithIncreasedAccuracy)
print(boolean)
print(text)
print(array)
print(dictionary)
print(set)


//:
//: -------------------
//:
//: ## Task:
//:
//: Go back to the code above and remove the type annotation for each variable.
//:
//: Are all the correct types set properly based on the type of each initial value?
//:
//: Correct any mistakes to ensure each type is correct removing the type annotation where possible.
//:
//: -------------------
//:
//: [Next Page  ▶](@next)
//:
//: -------------------
//:
